<?php
/* --------------------------------------------------------------
   EasyCreditHeaderExtender.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class EasyCreditHeaderExtender extends EasyCreditHeaderExtender_parent
{
    public function proceed()
    {
        parent::proceed();
        
        if(strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) !== 'true') {
            return;
        }

        if ($_SESSION['currency'] !== 'EUR') {
            return;
        }
        
        $shopId = gm_get_conf('GAMBIO_HUB_REMOTE_CONFIG_EASYCREDITHUB_SHOPID');
        if (empty($shopId)) {
            return;
        }
        $euro = (string)gm_get_conf('GAMBIO_HUB_REMOTE_CONFIG_EASYCREDITHUB_EURO');
        if (empty($euro)) {
            $euro = 'ISO';
        }
        $textVariante = (string)gm_get_conf('GAMBIO_HUB_REMOTE_CONFIG_EASYCREDITHUB_TEXTVARIANTE');
        if (empty($textVariante)) {
            $textVariante = 'OHNE_RATE';
        }
        
        $langText = MainFactory::create('LanguageTextManager', 'gambio_hub_easycredit');
        
        $easyCreditParameters = [
            'shopId'              => $shopId,
            'finanzierungsbetrag' => 0,
            'euro'                => $euro,
            'textVariante'        => $textVariante,
            'linkText'            => $langText->get_text('widget_linktext'),
            'fromText'            => $langText->get_text('widget_fromtext'),
            'installmentTemplate' => $langText->get_text('widget_installmenttemplate'),
            'widgetTemplate'      => $langText->get_text('widget_widgettemplate'),
        ];
        /** @var \product_ORIGIN $product */
        $product = $GLOBALS['product'];
        /** @var \xtcPrice_ORIGIN $xtcPrice */
        $xtcPrice = $GLOBALS['xtPrice'];
        if ($product->isProduct()) {
            $productsPrice                               = (float)$product->data['products_price'];
            $productsTaxClassId                          = $product->data['products_tax_class_id'];
            $easyCreditParameters['finanzierungsbetrag'] = $xtcPrice->xtcFormat($productsPrice, false,
                $productsTaxClassId);
        } elseif (strpos($_SERVER['REQUEST_URI'], 'shopping_cart.php') !== false) {
            /** @var \shoppingCart_ORIGIN $cart */
            $cart                = $_SESSION['cart'];
            $finanzierungsBetrag = $cart->show_total();
            if ($finanzierungsBetrag > 0) {
                $globalsOrder     = $GLOBALS['order'];
                $GLOBALS['order'] = new order();
                $orderTotal       = new order_total();
                $orderTotal->process();
                $shippingCost                                = $xtcPrice->xtcFormat($GLOBALS['order']->info['shipping_cost'],
                    false);
                $finanzierungsBetrag                         += $shippingCost;
                $GLOBALS['order']                            = $globalsOrder;
                $easyCreditParameters['finanzierungsbetrag'] = $finanzierungsBetrag;
            }
        } else {
            return;
        }
        
        if (!is_array($this->v_output_buffer)) {
            $this->v_output_buffer = [];
        }
        
        $this->v_output_buffer[] = '<script>let easyCreditParameters = ' . json_encode($easyCreditParameters)
                                   . ';</script>';
        
        if (file_exists(DIR_FS_CATALOG . '/.dev-environment')) {
            $loaderSrc = 'GXModules/Gambio/Hub/Shop/Javascript/EasyCreditLoader.js';
        } else {
            $loaderSrc = 'GXModules/Gambio/Hub/Build/Shop/Javascript/EasyCreditLoader.min.js';
        }
        $this->v_output_buffer[] = '<script src="' . $loaderSrc . '" async></script>';
    }
}

